/* 
 *  InteractionRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.InteractionNotFoundException;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseInteraction;

/**
 * This class is a base class for Interaction requests.
 */
public abstract class InteractionRequest extends SessionRequest {

    private final String interactionID;

    public InteractionRequest(Logger LOG, String interactionID) {
        super(LOG);
        this.interactionID = interactionID;
    }

    /**
     * A reference is not maintained to the InteractionI, instead a lookup is
     * performed based on the id. This is done to ensure the RefClient does not
     * prevent SDK objects from being garbage collected. If this methods throws
     * an exception the base Request class will catch it.
     * @return InteractionI obtained from SDK based on id
     * @throws com.avaya.ccs.api.exceptions.InvalidArgumentException 
     * @throws com.avaya.ccs.api.exceptions.ObjectInvalidException 
     * @throws com.avaya.ccs.javafxrefclient.InteractionNotFoundException 
     */
    public InteractionI getInteraction() throws InvalidArgumentException, ObjectInvalidException, InteractionNotFoundException {
        InteractionI interaction = getSession().findInteraction(getInteractionID());
        if (interaction == null) {
            throw new InteractionNotFoundException(getInteractionID());
        } else {
            return interaction;
        }
    }

    public String getInteractionID() {
        return interactionID;
    }
}
